
MEMORY {
    // Start the application at xxx
	dram_memory  : ORIGIN = 0x3f100000,	 	LENGTH = 100K
    flash_16_5   : org = 0x18f9c000, 		LENGTH = 16K	
    flash_memory : ORIGIN = 0x19000000,     LENGTH = 3584K
	qspi_memory : ORIGIN = 0x20000000,     LENGTH = 64M
}
DEFAULTS {

    heap_reserve = 16K
    stack_reserve = 4K

}
//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{

//
// ROM SECTIONS
//
    .bh                             : > flash_16_5
    .qspi 					        : > qspi_memory
    .text 					        : > flash_memory
    .syscall					        : > .
    .intercall					        : > .
    .interfunc  				        : > .

    .rodata 					        : > .
    .sdata2 					        : > .

    .secinfo 					        : > .
    .fixaddr 					        : > .
    .fixtype 					        : > .
    
    .CROM.sdata  	                   CROM(.sdata) : > .
    .CROM.data 	                            CROM(.data) : > .
	.intvec    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */
	
//
// RAM SECTIONS
//

    .sdabase 					        : > dram_memory	
    .sbss 					        : > .
    .sdata 					        : > .
    .data 					        : > .
    .bss 					        : > .
    .ghcovfz					  CLEAR : > .
    .ghcovcz					  CLEAR : > .
    .ghcovdz					  CLEAR : > .
    .heap                   ALIGN(16) PAD( heap_reserve +
	    // Add space for call-graph profiling if used:
	    (isdefined(__ghs_indgcount)?(2000+(sizeof(.text)/2)):0) +
	    // Add estimated space for call-count profiling if used:
	    (isdefined(__ghs_indmcount)?10000:0) )
	    						: > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

  
//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
	
    __ghs_romstart  = MEMADDR(flash_memory);
    __ghs_romend    = MEMENDADDR(flash_memory);
    __ghs_ramstart  = MEMADDR(dram_memory);
    __ghs_ramend    = MEMENDADDR(dram_memory);	

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;


	/* Stack Address Parameters */
	__SP_INIT      = ADDR(.stack) + SIZEOF(.stack);
	
	p_tabsSAM	= (0x3EF00000);
	p_stage_tcSAM = (p_tabsSAM + 0x13900);	
	p_baseSAM	= (p_stage_tcSAM + 0x13900);	

	__CONTRAM_start    = (0x80000000);//(0x3EF00000);//(p_stage_tcSAM);
	__CONTRAM_start_GPU    =(__CONTRAM_start + 128K);
	__CONTRAM_end        = (__CONTRAM_start_GPU + 880K);    	
	
}

